### Federated Unlearning

Federated unlearning is a concept proposed in the recent research literature that uses an unlearning algorithm, such as retraining from scratch, to guarantee that a client is able to remove all the effects of its local private data samples from the trained model. In its implementation in `fedunlearning_server.py` and `fedunlearning_client.py`, an implementation of federated unlearning overrides several methods in the client and server APIs, such as the server's `aggregate_deltas()`.

```bash
cd examples/unlearning/fedunlearning
uv run fedunlearning.py -c fedunlearning_adahessian_MNIST_lenet5.yml
```

**Note:** If the AdaHessian optimizer is used as in the example configuration file, it will reflect what the following paper proposed:

Yi Liu, Lei Xu, Xingliang Yuan, Cong Wang, Bo Li. "[The Right to be Forgotten in Federated Learning: An Efficient Realization with Rapid Retraining](https://arxiv.org/abs/2203.07320)," in Proc. INFOCOM, 2022.

---

### Knot

Knot is implemented in `examples/unlearning`, which clusters the clients, and the server aggregation is carried out within each cluster only. Knot is designed under **asynchronous** mode, and unlearned by retraining from scratch in cluster. The global model will be aggregated at the end of the retraining process. Knot supports a wide range of tasks, including image classification and language tasks.

```bash
cd examples/unlearning/knot
uv run knot.py -c knot_cifar10_resnet18.yml
uv run knot.py -c knot_mnist_lenet5.yml
uv run knot.py -c knot_purchase.yml
```

!!! tip "Running on macOS"

    This example depends on `cvxopt`, which requires several system-level libraries for compilation:

    ```bash
    brew install suite-sparse gsl glpk fftw
    ```

    If you run into the following error:

    ```
    src/C/umfpack.c:23:10: fatal error: 'umfpack.h' file not found
    ```

    This is because the `UMFPACK` headers from `SuiteSparse` cannot be found. Set the proper environment variables before running:

    ```bash
    export CVXOPT_BUILD_GLPK=0
    export CVXOPT_BUILD_FFTW=0
    export CVXOPT_BUILD_GSL=0
    export CVXOPT_BUILD_DSDP=0
    export CVXOPT_SUITESPARSE_LIB_DIR=/opt/homebrew/opt/suite-sparse/lib
    export CVXOPT_SUITESPARSE_INC_DIR=/opt/homebrew/opt/suite-sparse/include/suitesparse
    ```

!!! warning "Important"
    Make sure you have a valid [Mosek license](https://www.mosek.com/products/academic-licenses/) before proceeding, as the [Mosek optimization solver](https://mosek.com) has been used.

**Reference:** N. Su, B. Li. "[Asynchronous Federated Unlearning](https://iqua.ece.toronto.edu/papers/ningxinsu-infocom23.pdf)," in Proc. IEEE International Conference on Computer Communications (INFOCOM 2023).
